*************************************
*** This do-file creates Figure 7 ***
*************************************

clear
clear matrix
set matsize 4000
set mem 700m


* !!! PLEASE SPECIFY !!! the directory where the file nj_respondents_new.dta is stored:
local njdir=""

* load raw file
use `njdir'nj_respondents_new.dta, clear

drop if age < 20
drop if age > 65

* keep one observation per person
keep if week==1
keep week weekspaid* coh* lpdate date_new_claim baseearn_tc90 ind* educ* b3 perswgt curwkwgt id b3* age* female married r_* ethn*

drop educsvy_1

gen lbaseearn_tc90 = log(baseearn_tc90)
reg lbaseearn_tc90 age agesq female married educsvy_* r_black r_asoth r_na ethnic_hisp ethnic_na ind_* [pw=perswgt]
predict lres, res

gen beres = exp(10.2+lres)

tabstat age married educ educsvy_* r_black r_asoth r_na ethnic_hisp ethnic_na [aw=perswgt], by(coh) stats(mean median)

* create 40 weekly observations for each respondent
expand 40
drop week

sort id
by id: gen week = _n+1
by id: gen intday = 18168 + week*7

gen     weekspaid_allc = 0 if coh==1
replace weekspaid_allc = 10 if coh==2
replace weekspaid_allc = 20 if coh==3
replace weekspaid_allc = 30 if coh==4
replace weekspaid_allc = 40 if coh==5
replace weekspaid_allc = 50 if coh==6
replace weekspaid_allc = 60 if coh==7
replace weekspaid_allc = 70 if coh==8

gen udur = weekspaid_allc + week

gen intdayold = intday
replace intday = intday - 7*(weekspaid_all - weekspaid_allc)

* drop individual if no longer on UI (lpdate = last payment date) and no new claim
drop if intday>lpdate & date_new_claim==.
*& weekspaid_all_end < potdur_extnew

* drop if weekly observation after end of survey period
drop if intdayold>18273 & weekspaid_all< 59
drop if intdayold>18364 + 35 & weekspaid_all>=60

save temp_figdur.dta, replace

local variables "baseearn_tc90 educ_hs ind_manu ind_eduhealth"

foreach yvar of local variables {
use temp_figdur.dta, clear

if "`yvar'" == "baseearn_tc90" {
gen vart = `yvar'
local varx_m = 32000
local varx_p = 44000
local varx_d = 4000
local ttitle = "Earnings in base year"
local ytitle = ""
}

if "`yvar'" == "beres" {
gen vart = beres
local varx_m = 32000
local varx_p = 42000
local varx_d = 2000
local ttitle = "Earnings in base year (residual)"
local ytitle = "$"
}

if "`yvar'" == "educ_hs" {
gen vart = (b3<=2) & b3!=.
local varx_m = 0.3
local varx_p = 0.45
local varx_d = 0.05
local ttitle = "Fraction with high school degree or less"
local ytitle = ""
}

if "`yvar'" == "educ_sco" {
gen vart = (b3==3) & b3!=.
local varx_m = 0.27
local varx_p = 0.42
local varx_d = 0.05
local ttitle = "Fraction with some college education"
local ytitle = ""
}

if "`yvar'" == "educ_col" {
gen vart = (b3>=4) & b3!=.
local varx_m = 0.2
local varx_p = 0.35
local varx_d = 0.05
local ttitle = "Fraction with college degree"
local ytitle = ""
}

if "`yvar'" == "educ_scolp" {
gen vart = (b3>=3) & b3!=.
local varx_m = 0.2
local varx_p = 0.35
local varx_d = 0.05
local ttitle = "Fraction with some college or more"
local ytitle = ""
}


if "`yvar'" == "ind_eduhealth" {
gen vart = ind_eduhealth
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in education or health services"
local ytitle = ""
}

if "`yvar'" == "ind_manu" {
gen vart = ind_manu
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in manufacturing"
local ytitle = ""
}

if "`yvar'" == "ind_cons" {
gen vart = ind_cons
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in construction"
local ytitle = ""
}

if "`yvar'" == "ind_fin" {
gen vart = ind_fin
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in finance or insurance"
local ytitle = ""
}

if "`yvar'" == "ind_agr" {
gen vart = ind_fin
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in agriculture"
local ytitle = ""
}

if "`yvar'" == "ind_minutil" {
gen vart = ind_min + ind_util
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in mining or utilities"
local ytitle = ""
}

if "`yvar'" == "ind_wholesale" {
gen vart = ind_wholesale
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in wholesale"
local ytitle = ""
}

if "`yvar'" == "ind_retail" {
gen vart = ind_wholesale
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in retail"
local ytitle = ""
}

if "`yvar'" == "ind_wholeret" {
gen vart = ind_wholesale + ind_retail
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in wholesale or retail"
local ytitle = ""
}


if "`yvar'" == "ind_transp" {
gen vart = ind_wholesale
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in transportation"
local ytitle = ""
}

if "`yvar'" == "ind_info" {
gen vart = ind_info
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in information services"
local ytitle = ""
}

if "`yvar'" == "ind_realest" {
gen vart = ind_realest
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in real estate"
local ytitle = ""
}

if "`yvar'" == "ind_techn" {
gen vart = ind_wholesale
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in technical services"
local ytitle = ""
}

if "`yvar'" == "ind_manaadm" {
gen vart = ind_mana + ind_adm
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in managerial or administrative services"
local ytitle = ""
}

if "`yvar'" == "ind_arts" {
gen vart = ind_arts
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in arts"
local ytitle = ""
}

if "`yvar'" == "ind_oth" {
gen vart = ind_acco + ind_othserv + ind_arts
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in other services"
local ytitle = ""
}

if "`yvar'" == "ind_publadm" {
gen vart = ind_publadm
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in public administration"
local ytitle = ""
}

if "`yvar'" == "ind_na" {
gen vart = ind_na
local varx_m = 0
local varx_p = 0.15
local varx_d = 0.05
local ttitle = "Fraction in industry not available"
local ytitle = ""
}


keep vart udur coh perswgt
collapse vart  (count) N=vart [aw=perswgt], by(udur coh)

* drop if N < 50

drop N


reshape wide vart, i(udur) j(coh)

graph twoway line vart1 vart2 vart3 vart4 vart5 vart6 vart7 vart8 udur if udur<=99, ///
legend(off) lwidth(medthick medthick medthick medthick medthick medthick medthick medthick) ///
title("`ttitle'", size(medium)) ytitle("`ytitle'") xtitle("Unemployment duration, in weeks", size(small)) ///
graphregion(color(white)) ///
yscale(range(`varx_m'(`varx_d')`varx_p')) ylabel(`varx_m'(`varx_d')`varx_p') ///
saving(`njdir'figdur_`yvar'.gph, replace)
graph export `njdir'figdur_`yvar'.png, replace hei(1200) wid(1650)

}


* figure 7
graph combine figdur_baseearn_tc90.gph figdur_educ_hs.gph figdur_ind_eduhealth.gph figdur_ind_manu.gph, ///
graphregion(color(white)) imargin(small)
graph export `njdir'figdur_combine.png, replace hei(1200) wid(1650)
graph export `njdir'figdur_combine.eps, replace





